from pydantic import BaseModel, Field, EmailStr
from datetime import datetime
from typing import Optional, Literal
from bson import ObjectId
from enum import Enum

class Address(BaseModel):
    street: str
    city: str
    state: str
    country: str
    postal_code: str

class Status(str, Enum):
    ACTIVE = "active"
    INACTIVE = "inactive"
    MAINTENANCE = "maintenance"

class CustomerBase(BaseModel):
    account_id: str
    user_id: str
    first_name: str
    last_name: str
    email: Optional[EmailStr]
    phone: Optional[str]
    address: Address
    customer_type: Literal["individual", "enterprise"]
    customer_accounts_id: Optional[str] = None
    status: Status = Field(default=Status.ACTIVE)
    company_name: Optional[str] = None
    contact_person: Optional[str] = None
    customer_id: Optional[int] = None

class CustomerCreate(CustomerBase):
    pass

class CustomerUpdate(BaseModel):
    first_name: Optional[str]
    last_name: Optional[str]
    email: Optional[EmailStr]
    phone: Optional[str]
    address: Optional[Address]
    customer_type: Optional[Literal["individual", "enterprise"]]
    customer_accounts_id: Optional[str] = None
    updated_date: Optional[datetime] = Field(default_factory=datetime.utcnow)

class Customer(CustomerBase):
    #id: Optional[str] = Field(default=None, alias="_id")
    id: Optional[str] = None
    customer_id: Optional[int] = None
    created_date: datetime = Field(default_factory=datetime.utcnow)
    updated_date: datetime = Field(default_factory=datetime.utcnow)

    class Config:
        populate_by_name = True  # For compatibility with `alias`
        json_encoders = {ObjectId: str}

class CustomersList(BaseModel):
    total_count: int
    users: list[Customer]
